#import "PMDisplapertureController.h"
#import "PMDisplapertureWindow.h"
#import "PMDisplapertureView.h"


#define NUMBER_OF_ANIMATION_STEPS 7
#define ANIMATION_INTERVAL 0.02


@implementation PMDisplapertureController

	+ (void)setAffectsAllScreens: (BOOL)flag {
		[[NSUserDefaults standardUserDefaults] setBool: flag forKey: @"Affect All Screens"];
	}

	+ (BOOL)affectsAllScreens {
		return [[NSUserDefaults standardUserDefaults] boolForKey: @"Affect All Screens"];
	}

	+ (void)setAffect: (BOOL)flag corner: (NSInteger)theCorner {
		[[NSUserDefaults standardUserDefaults] setBool: flag forKey: [NSString stringWithFormat: @"Affect Corner %d", theCorner]];
	}

	+ (BOOL)affectCorner: (NSInteger)theCorner {
		id theSettingsObject = [[NSUserDefaults standardUserDefaults] objectForKey: [NSString stringWithFormat: @"Affect Corner %d", theCorner]];
		if (theSettingsObject) {
			return [theSettingsObject boolValue];
		}
		return YES;
	}

	+ (void)setRadius: (NSInteger)theRadius {
		[[NSUserDefaults standardUserDefaults] setInteger: theRadius forKey: @"Radius"];
	}

	+ (NSInteger)radius {
		id theSettingsObject = [[NSUserDefaults standardUserDefaults] objectForKey: @"Radius"];
		if (theSettingsObject) {
			return [theSettingsObject intValue];
		}
		return 10;
	}

	- (void)positionDisplapertureWindows: (id)sender {
		BOOL isRepositioning;
		if (displapertureWindows) {
			isRepositioning = YES;
			NSDisableScreenUpdates();
			[displapertureWindows makeObjectsPerformSelector: @selector(close)];
			[displapertureWindows removeAllObjects];
		} else {
			isRepositioning = NO;
			displapertureWindows = [[NSMutableArray array] retain];
		}
		NSArray *theScreens = [NSScreen screens];
		if (([theScreens count]>1) && (![[self class] affectsAllScreens])) {
			theScreens = [NSArray arrayWithObject: [theScreens objectAtIndex: 0]];
		}
		NSScreen *aScreen;
		PMDisplapertureWindow *aWindow;
		PMDisplapertureView *aView;
		NSRect aFrame;
		for (aScreen in theScreens) {
			aFrame = [aScreen frame];
			aWindow = [[PMDisplapertureWindow alloc] initWithContentRect: aFrame styleMask: NSBorderlessWindowMask backing: NSBackingStoreBuffered defer: NO];
			[displapertureWindows addObject: aWindow];
			[aWindow release];
			[aWindow setReleasedWhenClosed: NO];
			[aWindow setOpaque: NO];
			[aWindow setAlphaValue: (isRepositioning ? 1.0 : 0.0)];
			[aWindow setHasShadow: NO];
			aView = [[PMDisplapertureView alloc] initWithFrame: aFrame];
			[aWindow setContentView: aView];
			[aView release];
			[aWindow orderFront: self];
			[aWindow setLevel: NSScreenSaverWindowLevel - 1];
		}
		if (isRepositioning) {
			NSEnableScreenUpdates();
		} else {
			CGFloat theAlphaValue = 0.0;
			CGFloat theAlphaStep = 1.0 / (CGFloat)NUMBER_OF_ANIMATION_STEPS;
			NSUInteger i;
			for (i = 1; i<NUMBER_OF_ANIMATION_STEPS; i++) {
				theAlphaValue += theAlphaStep;
				for (aWindow in displapertureWindows) {
					[aWindow setAlphaValue: theAlphaValue];
				}
				[NSThread sleepForTimeInterval: ANIMATION_INTERVAL];
			}
			for (aWindow in displapertureWindows) {
				[aWindow setAlphaValue: 1.0];
			}
		}
	}

	- (void)positionSettingsWindow {
		if (!settingsWindow) {
			if (![NSBundle loadNibNamed: @"Settings" owner: self]) {
				NSLog(@"cannot load <Settings.nib>");
				NSBeep();
				return;
			}
			[settingsWindow setHidesOnDeactivate: NO];
			[settingsWindow setLevel: NSNormalWindowLevel];
			Class theClass = [self class];
			[scopeSelector selectItemWithTag: ([theClass affectsAllScreens] ? 1 : 0)];
			[topLeftSwitch setState: ([theClass affectCorner: 1] ? NSOnState : NSOffState)];
			[topRightSwitch setState: ([theClass affectCorner: 2] ? NSOnState : NSOffState)];
			[bottomLeftSwitch setState: ([theClass affectCorner: 3] ? NSOnState : NSOffState)];
			[bottomRightSwitch setState: ([theClass affectCorner: 4] ? NSOnState : NSOffState)];
//			[radiusSlider setMaxValue: (double)([[[NSScreen screens] objectAtIndex: 0] frame].size.height / 2)];
			[radiusSlider setIntegerValue: [theClass radius]];
		}
		if (![settingsWindow isVisible]) {
			[settingsWindow center];
		}
		[settingsWindow makeKeyAndOrderFront: self];
		[NSApp activateIgnoringOtherApps: YES];
	}

	- (void)applicationDidFinishLaunching: (NSNotification*)theNotification {
		[self positionDisplapertureWindows: self];
		if (![[NSUserDefaults standardUserDefaults] boolForKey: @"Shown Settings"]) {
			[self positionSettingsWindow];
			[[NSUserDefaults standardUserDefaults] setBool: YES forKey: @"Shown Settings"];
		}
	}

	- (BOOL)applicationShouldHandleReopen: (NSApplication*)theApplication hasVisibleWindows: (BOOL)flag {
		[self positionSettingsWindow];
		return NO;
	}

	- (void)applicationDidChangeScreenParameters: (NSNotification*)theNotification {
//		[radiusSlider setMaxValue: (double)([[[NSScreen screens] objectAtIndex: 0] frame].size.height / 2)];
		[self positionDisplapertureWindows: theNotification];
	}

	- (IBAction)toggleScope: (id)sender {
		[[self class] setAffectsAllScreens: ([sender selectedTag]==1)];
		[self positionDisplapertureWindows: sender];
	}

	- (IBAction)toggleCorner: (id)sender {
		[[self class] setAffect: ([sender state]==NSOnState) corner: [sender tag]];
		[self positionDisplapertureWindows: sender];
	}

	- (IBAction)changeRadius: (id)sender {
		[[self class] setRadius: [sender integerValue]];
		[self positionDisplapertureWindows: sender];
	}

	- (IBAction)doSomething: (id)sender {
		if ([sender selectedSegment]==0) {
			[NSApp orderFrontStandardAboutPanel: sender];
		} else {
			[NSApp terminate: sender];
		}
	}

	- (void)dealloc {
		[displapertureWindows makeObjectsPerformSelector: @selector(close)];
		[displapertureWindows release];
		[super dealloc];
	}

@end
