#import "PMDisplapertureView.h"
#import "PMDisplapertureController.h"


@implementation PMDisplapertureView

	- (BOOL)isOpaque {
		return NO;
	}

	- (void)drawRect: (NSRect)theTargetRect {
		theTargetRect = [self bounds];
		[[NSColor clearColor] set];
		NSRectFill(theTargetRect);
		[[NSColor blackColor] set];
		CGFloat theRadius = (CGFloat)[PMDisplapertureController radius];
		NSBezierPath *aPath;
		if ([PMDisplapertureController affectCorner: 1]) {
			aPath = [NSBezierPath bezierPath];
			[aPath moveToPoint: NSMakePoint(NSMinX(theTargetRect), NSMaxY(theTargetRect) - theRadius)];
			[aPath appendBezierPathWithArcFromPoint: NSMakePoint(NSMinX(theTargetRect), NSMaxY(theTargetRect)) toPoint: NSMakePoint(NSMinX(theTargetRect) + theRadius, NSMaxY(theTargetRect)) radius: theRadius];
			[aPath lineToPoint: NSMakePoint(NSMinX(theTargetRect), NSMaxY(theTargetRect))];
			[aPath closePath];
			[aPath setLineWidth: 0.0];
			[aPath fill];
		}
		if ([PMDisplapertureController affectCorner: 2]) {
			aPath = [NSBezierPath bezierPath];
			[aPath moveToPoint: NSMakePoint(NSMaxX(theTargetRect), NSMaxY(theTargetRect) - theRadius)];
			[aPath appendBezierPathWithArcFromPoint: NSMakePoint(NSMaxX(theTargetRect), NSMaxY(theTargetRect)) toPoint: NSMakePoint(NSMaxX(theTargetRect) - theRadius, NSMaxY(theTargetRect)) radius: theRadius];
			[aPath lineToPoint: NSMakePoint(NSMaxX(theTargetRect), NSMaxY(theTargetRect))];
			[aPath closePath];
			[aPath setLineWidth: 0.0];
			[aPath fill];
		}
		if ([PMDisplapertureController affectCorner: 3]) {
			aPath = [NSBezierPath bezierPath];
			[aPath moveToPoint: NSMakePoint(NSMinX(theTargetRect), NSMinY(theTargetRect) + theRadius)];
			[aPath appendBezierPathWithArcFromPoint: NSMakePoint(NSMinX(theTargetRect), NSMinY(theTargetRect)) toPoint: NSMakePoint(NSMinX(theTargetRect) + theRadius, NSMinY(theTargetRect)) radius: theRadius];
			[aPath lineToPoint: NSMakePoint(NSMinX(theTargetRect), NSMinY(theTargetRect))];
			[aPath closePath];
			[aPath setLineWidth: 0.0];
			[aPath fill];
		}
		if ([PMDisplapertureController affectCorner: 4]) {
			aPath = [NSBezierPath bezierPath];
			[aPath moveToPoint: NSMakePoint(NSMaxX(theTargetRect), NSMinY(theTargetRect) + theRadius)];
			[aPath appendBezierPathWithArcFromPoint: NSMakePoint(NSMaxX(theTargetRect), NSMinY(theTargetRect)) toPoint: NSMakePoint(NSMaxX(theTargetRect) - theRadius, NSMinY(theTargetRect)) radius: theRadius];
			[aPath lineToPoint: NSMakePoint(NSMaxX(theTargetRect), NSMinY(theTargetRect))];
			[aPath closePath];
			[aPath setLineWidth: 0.0];
			[aPath fill];
		}
	}

@end
